unit SrviceLibrary1;

interface

uses SysUtils, Common1,
     SensorGroup01, SensorGroup02, SensorHorizon01, SensorGroup04;

// ==========================================================================
//     
// ==========================================================================
type TRequest = record
  //  
  RqCmd   : string;      //    
  //  
  Buffer  : pointer;     //    nil
  BufSize : integer;     //    
end;

// ==========================================================================
//      
// ==========================================================================
// . unit Common1

// ==========================================================================
//    
// ==========================================================================
//   
function UserDispatch(var Request : TRequest) : boolean;

// ==========================================================================
// --------------------------------------------------------------------------
implementation
// --------------------------------------------------------------------------
// ==========================================================================

// ==========================================================================
//     
// ==========================================================================
// --------------------------------------------------------------------------
//   'REC1'
procedure RunREC1();
var Ind : integer;
begin
   Randomize;
   //   
   FillChar(REC1, SizeOf(REC1), #0);
   //   
   REC1.Id := 'REC1';
   //   
   for Ind := Low(REC1.Arr) to High(REC1.Arr)
   do begin
      if Ind > High(SensorsArr01) then Exit;
      if Assigned(SensorsArr01[Ind])
      then REC1.Arr[Ind] := SensorsArr01[Ind].Value;
   end;
end;
// --------------------------------------------------------------------------
//   'REC2'
procedure RunREC2();
var Ind : integer;
begin
  Randomize;
   //   
   FillChar(REC2, SizeOf(REC2), #0);
   //   
   REC2.Id := 'REC2';
   //   
   for Ind := Low(REC2.Arr) to High(REC2.Arr)
   do begin
      if Ind > High(SensorsArr02) then Exit;
      if Assigned(SensorsArr02[Ind])
      then REC2.Arr[Ind] := SensorsArr02[Ind].Value;
   end;
end;
// --------------------------------------------------------------------------
//   'REC3'
procedure RunREC3();
begin
   //   
   FillChar(REC3, SizeOf(REC3), #0);
   //   
   REC3.Id := 'REC3';
   //   
   if Assigned(Horizon)
   then begin
      REC3.Pith := Horizon.Pitch;
      REC3.Roll := Horizon.Roll;
   end;
end;
// --------------------------------------------------------------------------
//   'REC4'
procedure RunREC4();
var Ind : integer;
begin
  Randomize;
   //   
   FillChar(REC4, SizeOf(REC4), #0);
   //   
   REC4.Id := 'REC4';
   //   
   for Ind := Low(REC2.Arr) to High(REC2.Arr)
   do begin
      if Ind > High(SensorsArr04) then Exit;
      if Assigned(SensorsArr04[Ind])
      then REC4.Arr[Ind] := SensorsArr04[Ind].Value;
   end;
end;

// --------------------------------------------------------------------------
//   
function UserDispatch(var Request : TRequest) : boolean;
begin
   // -------------------
   //  
   Result := False;
   Request.Buffer  := nil;
   Request.BufSize := 0;
   //--------------------
   // 
   //--------------------
   //  'REC1'
   if UpperCase(Request.RqCmd) = 'REC1'
   then begin
      //   
      RunREC1();
      //     
      Request.Buffer  := Addr(REC1);
      Request.BufSize := SizeOF(REC1);
      Result := True;
      Exit;
   end;
   //--------------------
   //  'REC2'
   if UpperCase(Request.RqCmd) = 'REC2'
   then begin
      //   
      RunREC2();
      //     
      Request.Buffer  := Addr(REC2);
      Request.BufSize := SizeOF(REC2);
      Result := True;
      Exit;
   end;
   //--------------------
   //  'REC3'
   if UpperCase(Request.RqCmd) = 'REC3'
   then begin
      //   
      RunREC3();
      //     
      Request.Buffer  := Addr(REC3);
      Request.BufSize := SizeOF(REC3);
      Result := True;
      Exit;
   end;
   //--------------------
   //  'REC4'
   if UpperCase(Request.RqCmd) = 'REC4'
   then begin
      //   
      RunREC4();
      //     
      Request.Buffer  := Addr(REC4);
      Request.BufSize := SizeOF(REC4);
      Result := True;
      Exit;
   end;
end;

// --------------------------------------------------------------------------
// ==========================================================================
//  
// ==========================================================================
end.
